/* THIS FILE IS AUTOGENERATED FROM WebExtensionContentScript.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_WebExtensionContentScriptBinding_h
#define mozilla_dom_WebExtensionContentScriptBinding_h

#include "ChromeUtilsBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

namespace dom {

class MatchGlobOrUTF8String;
class MatchPatternSetOrStringSequence;
struct MozDocumentMatcherInitAtoms;
struct NativePropertyHooks;
struct OriginAttributesPatternDictionary;
class OwningMatchGlobOrUTF8String;
class OwningMatchPatternSetOrStringSequence;
class ProtoAndIfaceCache;
struct WebExtensionContentScriptInitAtoms;

} // namespace dom

namespace extensions {

class MatchGlob;
class MatchPatternSet;
class MozDocumentMatcher;
class WebExtensionContentScript;

} // namespace extensions

} // namespace mozilla

namespace mozilla::dom {

enum class ContentScriptRunAt : uint8_t {
  Document_start,
  Document_end,
  Document_idle,
  EndGuard_
};

namespace ContentScriptRunAtValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ContentScriptRunAt::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ContentScriptRunAt stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ContentScriptRunAtValues

bool
ToJSValue(JSContext* aCx, ContentScriptRunAt aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMatchGlobOrUTF8String& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMatchPatternSetOrStringSequence& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningMatchGlobOrUTF8String& aUnion);


void
ImplCycleCollectionUnlink(OwningMatchPatternSetOrStringSequence& aUnion);


class MatchGlobOrUTF8String
{
  enum TypeOrUninit
  {
    eUninitialized,
    eMatchGlob,
    eUTF8String
  };
public:
  enum class Type
  {
    eMatchGlob = TypeOrUninit::eMatchGlob,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::extensions::MatchGlob> > mMatchGlob;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  MatchGlobOrUTF8String(const MatchGlobOrUTF8String&) = delete;
  MatchGlobOrUTF8String& operator=(const MatchGlobOrUTF8String&) = delete;
public:
  explicit inline MatchGlobOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~MatchGlobOrUTF8String()
  {
    Uninit();
  }

  inline NonNull<mozilla::extensions::MatchGlob>&
  RawSetAsMatchGlob()
  {
    if (mType == eMatchGlob) {
      return mValue.mMatchGlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMatchGlob;
    return mValue.mMatchGlob.SetValue();
  }

  inline NonNull<mozilla::extensions::MatchGlob>&
  SetAsMatchGlob()
  {
    if (mType == eMatchGlob) {
      return mValue.mMatchGlob.Value();
    }
    Uninit();
    mType = eMatchGlob;
    return mValue.mMatchGlob.SetValue();
  }

  inline bool
  IsMatchGlob() const
  {
    return mType == eMatchGlob;
  }

  inline NonNull<mozilla::extensions::MatchGlob>&
  GetAsMatchGlob()
  {
    MOZ_RELEASE_ASSERT(IsMatchGlob(), "Wrong type!");
    return mValue.mMatchGlob.Value();
  }

  inline mozilla::extensions::MatchGlob&
  GetAsMatchGlob() const
  {
    MOZ_RELEASE_ASSERT(IsMatchGlob(), "Wrong type!");
    return mValue.mMatchGlob.Value();
  }

  inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMatchGlob: {
        DestroyMatchGlob();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToMatchGlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMatchGlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMatchGlob()
  {
    MOZ_RELEASE_ASSERT(IsMatchGlob(), "Wrong type!");
    mValue.mMatchGlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};


class OwningMatchGlobOrUTF8String : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMatchGlobOrUTF8String& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eMatchGlob,
    eUTF8String
  };
public:
  enum class Type
  {
    eMatchGlob = TypeOrUninit::eMatchGlob,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::extensions::MatchGlob> > mMatchGlob;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningMatchGlobOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningMatchGlobOrUTF8String(OwningMatchGlobOrUTF8String&& aOther);

  explicit inline OwningMatchGlobOrUTF8String(const OwningMatchGlobOrUTF8String& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMatchGlobOrUTF8String()
  {
    Uninit();
  }

  OwningNonNull<mozilla::extensions::MatchGlob>&
  RawSetAsMatchGlob();

  OwningNonNull<mozilla::extensions::MatchGlob>&
  SetAsMatchGlob();

  inline bool
  IsMatchGlob() const
  {
    return mType == eMatchGlob;
  }

  inline OwningNonNull<mozilla::extensions::MatchGlob>&
  GetAsMatchGlob()
  {
    MOZ_RELEASE_ASSERT(IsMatchGlob(), "Wrong type!");
    return mValue.mMatchGlob.Value();
  }

  inline OwningNonNull<mozilla::extensions::MatchGlob> const &
  GetAsMatchGlob() const
  {
    MOZ_RELEASE_ASSERT(IsMatchGlob(), "Wrong type!");
    return mValue.mMatchGlob.Value();
  }

  nsCString&
  RawSetAsUTF8String();

  nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningMatchGlobOrUTF8String&
  operator=(OwningMatchGlobOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningMatchGlobOrUTF8String&
  operator=(const OwningMatchGlobOrUTF8String& aOther);

private:
  bool
  TrySetToMatchGlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMatchGlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMatchGlob();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};


class MatchPatternSetOrStringSequence
{
  enum TypeOrUninit
  {
    eUninitialized,
    eMatchPatternSet,
    eStringSequence
  };
public:
  enum class Type
  {
    eMatchPatternSet = TypeOrUninit::eMatchPatternSet,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::extensions::MatchPatternSet> > mMatchPatternSet;
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  MatchPatternSetOrStringSequence(const MatchPatternSetOrStringSequence&) = delete;
  MatchPatternSetOrStringSequence& operator=(const MatchPatternSetOrStringSequence&) = delete;
public:
  explicit inline MatchPatternSetOrStringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~MatchPatternSetOrStringSequence()
  {
    Uninit();
  }

  inline NonNull<mozilla::extensions::MatchPatternSet>&
  RawSetAsMatchPatternSet()
  {
    if (mType == eMatchPatternSet) {
      return mValue.mMatchPatternSet.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMatchPatternSet;
    return mValue.mMatchPatternSet.SetValue();
  }

  inline NonNull<mozilla::extensions::MatchPatternSet>&
  SetAsMatchPatternSet()
  {
    if (mType == eMatchPatternSet) {
      return mValue.mMatchPatternSet.Value();
    }
    Uninit();
    mType = eMatchPatternSet;
    return mValue.mMatchPatternSet.SetValue();
  }

  inline bool
  IsMatchPatternSet() const
  {
    return mType == eMatchPatternSet;
  }

  inline NonNull<mozilla::extensions::MatchPatternSet>&
  GetAsMatchPatternSet()
  {
    MOZ_RELEASE_ASSERT(IsMatchPatternSet(), "Wrong type!");
    return mValue.mMatchPatternSet.Value();
  }

  inline mozilla::extensions::MatchPatternSet&
  GetAsMatchPatternSet() const
  {
    MOZ_RELEASE_ASSERT(IsMatchPatternSet(), "Wrong type!");
    return mValue.mMatchPatternSet.Value();
  }

  inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMatchPatternSet: {
        DestroyMatchPatternSet();
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToMatchPatternSet(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMatchPatternSet(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMatchPatternSet()
  {
    MOZ_RELEASE_ASSERT(IsMatchPatternSet(), "Wrong type!");
    mValue.mMatchPatternSet.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningMatchPatternSetOrStringSequence : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMatchPatternSetOrStringSequence& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eMatchPatternSet,
    eStringSequence
  };
public:
  enum class Type
  {
    eMatchPatternSet = TypeOrUninit::eMatchPatternSet,
    eStringSequence = TypeOrUninit::eStringSequence
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::extensions::MatchPatternSet> > mMatchPatternSet;
    UnionMember<Sequence<nsString> > mStringSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningMatchPatternSetOrStringSequence()
    : mType(eUninitialized)
  {
  }

  OwningMatchPatternSetOrStringSequence(OwningMatchPatternSetOrStringSequence&& aOther);

  explicit inline OwningMatchPatternSetOrStringSequence(const OwningMatchPatternSetOrStringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMatchPatternSetOrStringSequence()
  {
    Uninit();
  }

  OwningNonNull<mozilla::extensions::MatchPatternSet>&
  RawSetAsMatchPatternSet();

  OwningNonNull<mozilla::extensions::MatchPatternSet>&
  SetAsMatchPatternSet();

  inline bool
  IsMatchPatternSet() const
  {
    return mType == eMatchPatternSet;
  }

  inline OwningNonNull<mozilla::extensions::MatchPatternSet>&
  GetAsMatchPatternSet()
  {
    MOZ_RELEASE_ASSERT(IsMatchPatternSet(), "Wrong type!");
    return mValue.mMatchPatternSet.Value();
  }

  inline OwningNonNull<mozilla::extensions::MatchPatternSet> const &
  GetAsMatchPatternSet() const
  {
    MOZ_RELEASE_ASSERT(IsMatchPatternSet(), "Wrong type!");
    return mValue.mMatchPatternSet.Value();
  }

  Sequence<nsString>&
  RawSetAsStringSequence();

  Sequence<nsString>&
  SetAsStringSequence();

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_RELEASE_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningMatchPatternSetOrStringSequence&
  operator=(OwningMatchPatternSetOrStringSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningMatchPatternSetOrStringSequence&
  operator=(const OwningMatchPatternSetOrStringSequence& aOther);

private:
  bool
  TrySetToMatchPatternSet(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMatchPatternSet(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMatchPatternSet();

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStringSequence();
};


struct MozDocumentMatcherInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAllFrames;
  MOZ_INIT_OUTSIDE_CTOR bool mCheckPermissions;
  MOZ_INIT_OUTSIDE_CTOR Nullable<Sequence<OwningMatchGlobOrUTF8String>> mExcludeGlobs;
  MOZ_INIT_OUTSIDE_CTOR Nullable<OwningMatchPatternSetOrStringSequence > mExcludeMatches;
  MOZ_INIT_OUTSIDE_CTOR Nullable<uint64_t> mFrameID;
  MOZ_INIT_OUTSIDE_CTOR bool mHasActiveTabPermission;
  MOZ_INIT_OUTSIDE_CTOR Nullable<Sequence<OwningMatchGlobOrUTF8String>> mIncludeGlobs;
  MOZ_INIT_OUTSIDE_CTOR bool mMatchAboutBlank;
  MOZ_INIT_OUTSIDE_CTOR OwningMatchPatternSetOrStringSequence mMatches;
  MOZ_INIT_OUTSIDE_CTOR Nullable<Sequence<OriginAttributesPatternDictionary>> mOriginAttributesPatterns;

  MozDocumentMatcherInit();

  explicit inline MozDocumentMatcherInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MozDocumentMatcherInit(MozDocumentMatcherInit&& aOther) = default;

  explicit inline MozDocumentMatcherInit(const MozDocumentMatcherInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mExcludeGlobs, "mExcludeGlobs", aFlags);
    ImplCycleCollectionTraverse(aCallback, mExcludeMatches, "mExcludeMatches", aFlags);
    ImplCycleCollectionTraverse(aCallback, mIncludeGlobs, "mIncludeGlobs", aFlags);
    ImplCycleCollectionTraverse(aCallback, mMatches, "mMatches", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mExcludeGlobs);
    ImplCycleCollectionUnlink(mExcludeMatches);
    ImplCycleCollectionUnlink(mIncludeGlobs);
    ImplCycleCollectionUnlink(mMatches);
  }

  MozDocumentMatcherInit&
  operator=(const MozDocumentMatcherInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, MozDocumentMatcherInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozDocumentMatcherInit : public MozDocumentMatcherInit
{
  inline FastMozDocumentMatcherInit()
    : MozDocumentMatcherInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WebExtensionContentScriptInit : public MozDocumentMatcherInit
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mCssPaths;
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mJsPaths;
  MOZ_INIT_OUTSIDE_CTOR ContentScriptRunAt mRunAt;

  WebExtensionContentScriptInit();

  explicit inline WebExtensionContentScriptInit(const FastDictionaryInitializer& )
    : MozDocumentMatcherInit(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WebExtensionContentScriptInit(WebExtensionContentScriptInit&& aOther) = default;

  explicit inline WebExtensionContentScriptInit(const WebExtensionContentScriptInit& aOther)
    : MozDocumentMatcherInit(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    MozDocumentMatcherInit::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    MozDocumentMatcherInit::UnlinkForCC();
  }

  WebExtensionContentScriptInit&
  operator=(const WebExtensionContentScriptInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, WebExtensionContentScriptInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastWebExtensionContentScriptInit : public WebExtensionContentScriptInit
{
  inline FastWebExtensionContentScriptInit()
    : WebExtensionContentScriptInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MozDocumentMatcher_Binding {

  typedef mozilla::extensions::MozDocumentMatcher NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::extensions::MozDocumentMatcher* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MozDocumentMatcher,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MozDocumentMatcher,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::MozDocumentMatcher,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace MozDocumentMatcher_Binding



namespace WebExtensionContentScript_Binding {

  typedef mozilla::extensions::WebExtensionContentScript NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::extensions::WebExtensionContentScript* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::WebExtensionContentScript,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::WebExtensionContentScript,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::WebExtensionContentScript,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace WebExtensionContentScript_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_WebExtensionContentScriptBinding_h
