/* THIS FILE IS AUTOGENERATED FROM HTMLElement.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_HTMLELEMENTBINDING_H_
#define DOM_HTMLELEMENTBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

class nsGenericHTMLElement;

namespace mozilla {
namespace dom {

class HTMLUnknownElement;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

class BooleanOrUnrestrictedDoubleOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBoolean,
    eUnrestrictedDouble,
    eString
  };
public:
  enum class Type
  {
    eBoolean = TypeOrUninit::eBoolean,
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  BooleanOrUnrestrictedDoubleOrString(const BooleanOrUnrestrictedDoubleOrString&) = delete;
  BooleanOrUnrestrictedDoubleOrString& operator=(const BooleanOrUnrestrictedDoubleOrString&) = delete;
public:
  explicit inline BooleanOrUnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  inline ~BooleanOrUnrestrictedDoubleOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  [[nodiscard]] inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  [[nodiscard]] inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningBooleanOrUnrestrictedDoubleOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBoolean,
    eUnrestrictedDouble,
    eString
  };
public:
  enum class Type
  {
    eBoolean = TypeOrUninit::eBoolean,
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningBooleanOrUnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  OwningBooleanOrUnrestrictedDoubleOrString(OwningBooleanOrUnrestrictedDoubleOrString&& aOther);

  explicit inline OwningBooleanOrUnrestrictedDoubleOrString(const OwningBooleanOrUnrestrictedDoubleOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningBooleanOrUnrestrictedDoubleOrString()
  {
    Uninit();
  }

  [[nodiscard]] bool&
  RawSetAsBoolean();

  [[nodiscard]] bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  [[nodiscard]] double&
  RawSetAsUnrestrictedDouble();

  [[nodiscard]] double&
  SetAsUnrestrictedDouble();

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningBooleanOrUnrestrictedDoubleOrString&
  operator=(OwningBooleanOrUnrestrictedDoubleOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningBooleanOrUnrestrictedDoubleOrString&
  operator=(const OwningBooleanOrUnrestrictedDoubleOrString& aOther);

private:
  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();

  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedDouble();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


namespace HTMLElement_Binding {

  typedef nsGenericHTMLElement NativeType;

  bool
  Wrap(JSContext* aCx, nsGenericHTMLElement* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLElement,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace HTMLElement_Binding



namespace HTMLUnknownElement_Binding {

  typedef mozilla::dom::HTMLUnknownElement NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::HTMLUnknownElement* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLUnknownElement,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace HTMLUnknownElement_Binding



} // namespace mozilla::dom

#endif // DOM_HTMLELEMENTBINDING_H_
