// -*- mode: C++ -*-

/* This file is auto-generated by run_glean_parser.py.
   It is only for internal use by types in
   toolkit/components/glean/bindings/private */

#include "mozilla/AppShutdown.h"
#include "mozilla/ClearOnShutdown.h"
#include "mozilla/glean/bindings/GleanJSMetricsLookup.h"
#include "mozilla/glean/bindings/jog/JOG.h"
#include "mozilla/Maybe.h"
#include "mozilla/Telemetry.h"
#include "nsIThread.h"
#include "nsThreadUtils.h"

#ifndef mozilla_glean_ScalarGifftMap_h
#define mozilla_glean_ScalarGifftMap_h

#define DYNAMIC_METRIC_BIT (26)
#define GLEAN_METRIC_ID(id) ((id) & ((1ULL << 27) - 1))

namespace mozilla::glean {

using Telemetry::ScalarID;

static inline bool IsSubmetricId(uint32_t aId) {
  // Submetrics have the 2^25 bit set.
  // (ID_BITS - ID_SIGNAL_BITS, keep it in sync with js.py).
  return (aId & (1 << 25)) > 0;
}

static inline Maybe<ScalarID> ScalarIdForMetric(uint32_t aId) {
  switch(aId) {
    case 5: { // browser.backup.browser_extension_data_size
      return Some(ScalarID::BROWSER_BACKUP_BROWSER_EXTENSION_DATA_SIZE);
    }
    case 6: { // browser.backup.cookies_size
      return Some(ScalarID::BROWSER_BACKUP_COOKIES_SIZE);
    }
    case 7: { // browser.backup.credentials_data_size
      return Some(ScalarID::BROWSER_BACKUP_CREDENTIALS_DATA_SIZE);
    }
    case 8: { // browser.backup.extension_store_permissions_data_size
      return Some(ScalarID::BROWSER_BACKUP_EXTENSION_STORE_PERMISSIONS_DATA_SIZE);
    }
    case 9: { // browser.backup.extensions_json_size
      return Some(ScalarID::BROWSER_BACKUP_EXTENSIONS_JSON_SIZE);
    }
    case 10: { // browser.backup.extensions_storage_size
      return Some(ScalarID::BROWSER_BACKUP_EXTENSIONS_STORAGE_SIZE);
    }
    case 11: { // browser.backup.extensions_xpi_directory_size
      return Some(ScalarID::BROWSER_BACKUP_EXTENSIONS_XPI_DIRECTORY_SIZE);
    }
    case 12: { // browser.backup.favicons_size
      return Some(ScalarID::BROWSER_BACKUP_FAVICONS_SIZE);
    }
    case 13: { // browser.backup.form_history_size
      return Some(ScalarID::BROWSER_BACKUP_FORM_HISTORY_SIZE);
    }
    case 14: { // browser.backup.misc_data_size
      return Some(ScalarID::BROWSER_BACKUP_MISC_DATA_SIZE);
    }
    case 15: { // browser.backup.places_size
      return Some(ScalarID::BROWSER_BACKUP_PLACES_SIZE);
    }
    case 16: { // browser.backup.preferences_size
      return Some(ScalarID::BROWSER_BACKUP_PREFERENCES_SIZE);
    }
    case 17: { // browser.backup.prof_d_disk_space
      return Some(ScalarID::BROWSER_BACKUP_PROF_D_DISK_SPACE);
    }
    case 18: { // browser.backup.security_data_size
      return Some(ScalarID::BROWSER_BACKUP_SECURITY_DATA_SIZE);
    }
    case 19: { // browser.backup.session_store_backups_directory_size
      return Some(ScalarID::BROWSER_BACKUP_SESSION_STORE_BACKUPS_DIRECTORY_SIZE);
    }
    case 20: { // browser.backup.session_store_size
      return Some(ScalarID::BROWSER_BACKUP_SESSION_STORE_SIZE);
    }
    case 21: { // browser.backup.storage_sync_size
      return Some(ScalarID::BROWSER_BACKUP_STORAGE_SYNC_SIZE);
    }
    case 151: { // shopping.product_page_visits
      return Some(ScalarID::SHOPPING_PRODUCT_PAGE_VISITS);
    }
    case 179: { // shopping.settings.auto_open_user_disabled
      return Some(ScalarID::SHOPPING_AUTO_OPEN_USER_DISABLED);
    }
    case 180: { // shopping.settings.component_opted_out
      return Some(ScalarID::SHOPPING_COMPONENT_OPTED_OUT);
    }
    case 181: { // shopping.settings.disabled_ads
      return Some(ScalarID::SHOPPING_DISABLED_ADS);
    }
    case 182: { // shopping.settings.has_onboarded
      return Some(ScalarID::SHOPPING_HAS_ONBOARDED);
    }
    case 183: { // shopping.settings.nimbus_disabled_shopping
      return Some(ScalarID::SHOPPING_NIMBUS_DISABLED);
    }
    case 212: { // installation.first_seen.admin_user
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_ADMIN_USER);
    }
    case 213: { // installation.first_seen.default_path
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_DEFAULT_PATH);
    }
    case 214: { // installation.first_seen.failure_reason
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_FAILURE_REASON);
    }
    case 215: { // installation.first_seen.from_msi
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_FROM_MSI);
    }
    case 216: { // installation.first_seen.install_existed
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_INSTALL_EXISTED);
    }
    case 217: { // installation.first_seen.installer_type
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_INSTALLER_TYPE);
    }
    case 218: { // installation.first_seen.other_inst
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_OTHER_INST);
    }
    case 219: { // installation.first_seen.other_msix_inst
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_OTHER_MSIX_INST);
    }
    case 220: { // installation.first_seen.profdir_existed
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_PROFDIR_EXISTED);
    }
    case 221: { // installation.first_seen.silent
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_SILENT);
    }
    case 222: { // installation.first_seen.version
      return Some(ScalarID::INSTALLATION_FIRSTSEEN_VERSION);
    }
    case 2587: { // media.playback.device_hardware_decoder_support
      return Some(ScalarID::MEDIA_DEVICE_HARDWARE_DECODING_SUPPORT);
    }
    case 2799: { // networking.speculative_connect_outcome
      return Some(ScalarID::NETWORKING_SPECULATIVE_CONNECT_OUTCOME);
    }
    case 2807: { // network.data_size_pb_per_type
      return Some(ScalarID::NETWORKING_DATA_TRANSFERRED_PB_PER_CONTENT_TYPE);
    }
    case 2808: { // network.data_size_per_type
      return Some(ScalarID::NETWORKING_DATA_TRANSFERRED_PER_CONTENT_TYPE);
    }
    case 2868: { // cookie.banners.normal_window_service_mode
      return Some(ScalarID::COOKIE_BANNERS_NORMAL_WINDOW_SERVICE_MODE);
    }
    case 2869: { // cookie.banners.private_window_service_mode
      return Some(ScalarID::COOKIE_BANNERS_PRIVATE_WINDOW_SERVICE_MODE);
    }
    case 2871: { // cookie.banners.rule_lookup_by_domain
      return Some(ScalarID::COOKIE_BANNERS_RULE_LOOKUP_BY_DOMAIN);
    }
    case 2872: { // cookie.banners.rule_lookup_by_load
      return Some(ScalarID::COOKIE_BANNERS_RULE_LOOKUP_BY_LOAD);
    }
    case 2873: { // cookie.banners.service_detect_only
      return Some(ScalarID::COOKIE_BANNERS_SERVICE_DETECT_ONLY);
    }
    case 2878: { // cookie.banners.click.result
      return Some(ScalarID::COOKIE_BANNERS_CLICK_RESULT);
    }
    case 2929: { // extensions.startup_cache_load_time
      return Some(ScalarID::EXTENSIONS_STARTUPCACHE_LOAD_TIME);
    }
    case 2930: { // extensions.startup_cache_read_errors
      return Some(ScalarID::EXTENSIONS_STARTUPCACHE_READ_ERRORS);
    }
    case 2931: { // extensions.startup_cache_write_bytelength
      return Some(ScalarID::EXTENSIONS_STARTUPCACHE_WRITE_BYTELENGTH);
    }
    case 2934: { // extensions.apis.dnr.evaluate_rules_count_max
      return Some(ScalarID::EXTENSIONS_APIS_DNR_EVALUATE_RULES_COUNT_MAX);
    }
    case 2936: { // extensions.apis.dnr.startup_cache_entries
      return Some(ScalarID::EXTENSIONS_APIS_DNR_STARTUP_CACHE_ENTRIES);
    }
    case 2946: { // extensions.quarantined_domains.listhash
      return Some(ScalarID::EXTENSIONS_QUARANTINEDDOMAINS_LISTHASH);
    }
    case 2947: { // extensions.quarantined_domains.listsize
      return Some(ScalarID::EXTENSIONS_QUARANTINEDDOMAINS_LISTSIZE);
    }
    case 2948: { // extensions.quarantined_domains.remotehash
      return Some(ScalarID::EXTENSIONS_QUARANTINEDDOMAINS_REMOTEHASH);
    }
    case 2958: { // formautofill.creditcards.autofill_profiles_count
      return Some(ScalarID::FORMAUTOFILL_CREDITCARDS_AUTOFILL_PROFILES_COUNT);
    }
    case 2990: { // test_only.meaning_of_life
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_QUANTITY);
    }
    case 2991: { // test_only.mirror_time
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_TIMESPAN);
    }
    case 2992: { // test_only.mirror_time_nanos
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_TIMESPAN_NANOS);
    }
    case 2993: { // test_only.mirrors_for_labeled_bools
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_LABELED_BOOL);
    }
    case 2998: { // test_only.ipc.a_bool
      return Some(ScalarID::TELEMETRY_TEST_BOOLEAN_KIND);
    }
    case 2999: { // test_only.ipc.a_counter
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_COUNTER);
    }
    case 3001: { // test_only.ipc.a_date
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_DATE);
    }
    case 3002: { // test_only.ipc.a_labeled_counter
      return Some(ScalarID::TELEMETRY_TEST_ANOTHER_MIRROR_FOR_LABELED_COUNTER);
    }
    case 3005: { // test_only.ipc.a_string
      return Some(ScalarID::TELEMETRY_TEST_MULTIPLE_STORES_STRING);
    }
    case 3006: { // test_only.ipc.a_string_list
      return Some(ScalarID::TELEMETRY_TEST_KEYED_BOOLEAN_KIND);
    }
    case 3009: { // test_only.ipc.a_url
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_URL);
    }
    case 3010: { // test_only.ipc.a_uuid
      return Some(ScalarID::TELEMETRY_TEST_STRING_KIND);
    }
    case 3013: { // test_only.ipc.another_labeled_counter
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_LABELED_COUNTER);
    }
    case 3015: { // test_only.ipc.irate
      return Some(ScalarID::TELEMETRY_TEST_MIRROR_FOR_RATE);
    }
    case 3047: { // power.cpu_time_bogus_values
      return Some(ScalarID::POWER_CPU_TIME_BOGUS_VALUES);
    }
    case 3048: { // power.cpu_time_per_process_type_ms
      return Some(ScalarID::POWER_CPU_TIME_PER_PROCESS_TYPE_MS);
    }
    case 3051: { // power.gpu_time_bogus_values
      return Some(ScalarID::POWER_GPU_TIME_BOGUS_VALUES);
    }
    case 3052: { // power.gpu_time_per_process_type_ms
      return Some(ScalarID::POWER_GPU_TIME_PER_PROCESS_TYPE_MS);
    }
    case 3053: { // power.total_cpu_time_ms
      return Some(ScalarID::POWER_TOTAL_CPU_TIME_MS);
    }
    case 3054: { // power.total_gpu_time_ms
      return Some(ScalarID::POWER_TOTAL_GPU_TIME_MS);
    }
    case 3055: { // power.total_thread_wakeups
      return Some(ScalarID::POWER_TOTAL_THREAD_WAKEUPS);
    }
    case 3056: { // power.wakeups_per_process_type
      return Some(ScalarID::POWER_WAKEUPS_PER_PROCESS_TYPE);
    }
    case 3300: { // blocklist.mlbf_source
      return Some(ScalarID::BLOCKLIST_MLBF_SOURCE);
    }
    default: {
      if (MOZ_UNLIKELY(aId & (1 << DYNAMIC_METRIC_BIT))) {
        // Dynamic (runtime-registered) metric. Use its static (compiletime-
        // registered) metric's telemetry_mirror mapping.
        // ...if applicable.

        // Only JS can use dynamic (runtime-registered) metric ids.
        MOZ_ASSERT(NS_IsMainThread());

        auto metricName = JOG::GetMetricName(aId);
        // All of these should have names, but the storage only lasts until
        // XPCOMWillShutdown, so it might return `Nothing()`.
        if (metricName.isSome()) {
          auto maybeMetric = MetricByNameLookup(metricName.ref());
          if (maybeMetric.isSome()) {
            uint32_t staticId = GLEAN_METRIC_ID(maybeMetric.value());
            // Let's ensure we don't infinite loop, huh.
            MOZ_ASSERT(!(staticId & (1 << DYNAMIC_METRIC_BIT)));
            return ScalarIdForMetric(staticId);
          }
        }
      }
      return Nothing();
    }
  }
}

}  // namespace mozilla::glean

#undef GLEAN_METRIC_ID
#undef DYNAMIC_METRIC_BIT

#endif  // mozilla_glean_ScalarGifftMaps_h
