/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.log;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.LogDescriptor;
import org.torproject.descriptor.internal.FileType;
import org.torproject.descriptor.log.InternalLogDescriptor;
import org.torproject.descriptor.log.WebServerAccessLogImpl;

public abstract class LogDescriptorImpl
implements LogDescriptor,
InternalLogDescriptor {
    public static final String MARKER = ".log";
    private static final int unrecognizedLinesLimit = 3;
    private static Pattern filenamePattern = Pattern.compile("(?:\\S*).log_(?:[0-9a-zA-Z]*)(?:\\.?)([a-zA-Z2]*)");
    private final File descriptorFile;
    private byte[] logBytes;
    private FileType fileType;
    private List<String> unrecognizedLines = new ArrayList<String>();
    private InternalLogDescriptor.Validator validator = line -> true;

    protected LogDescriptorImpl(byte[] logBytes, File descriptorFile, String logName, FileType defaultCompression) throws DescriptorParseException {
        this.logBytes = logBytes;
        this.descriptorFile = descriptorFile;
        try {
            Matcher mat = filenamePattern.matcher(logName);
            if (!mat.find()) {
                throw new DescriptorParseException("Log file name doesn't comply to standard: " + logName);
            }
            this.fileType = FileType.findType(mat.group(1).toUpperCase());
            if (FileType.PLAIN == this.fileType) {
                this.fileType = defaultCompression;
                this.logBytes = this.fileType.compress(this.logBytes);
            }
        }
        catch (Exception ex) {
            throw new DescriptorParseException("Cannot parse file " + logName + " from file " + descriptorFile.getName(), ex);
        }
    }

    @Override
    public InputStream decompressedByteStream() throws DescriptorParseException {
        try {
            return this.fileType.decompress(new ByteArrayInputStream(this.logBytes));
        }
        catch (Exception ex) {
            throw new DescriptorParseException("Cannot provide deflated stream of " + this.descriptorFile + ".", ex);
        }
    }

    @Override
    public void validate() throws DescriptorParseException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.decompressedByteStream()));){
            this.unrecognizedLines.addAll(((Stream)br.lines().parallel()).filter(line -> null != line && !line.isEmpty() && !this.validator.validate((String)line)).limit(3L).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            throw new DescriptorParseException("Cannot validate log lines.", ex);
        }
    }

    public static List<Descriptor> parse(byte[] logBytes, File descriptorFile, String logName) throws DescriptorParseException {
        if (logName.contains("access.log")) {
            return Arrays.asList(new WebServerAccessLogImpl(logBytes, descriptorFile, logName));
        }
        throw new DescriptorParseException("Cannot parse file " + logName + " from file " + descriptorFile.getName());
    }

    @Override
    public void setValidator(InternalLogDescriptor.Validator validator) {
        this.validator = validator;
    }

    @Override
    public String getCompressionType() {
        return this.fileType.name().toLowerCase();
    }

    @Override
    public byte[] getRawDescriptorBytes() {
        return this.logBytes;
    }

    @Override
    public void setRawDescriptorBytes(byte[] bytes) {
        this.logBytes = bytes;
    }

    @Override
    public int getRawDescriptorLength() {
        return this.logBytes.length;
    }

    @Override
    public List<String> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getUnrecognizedLines() {
        return this.unrecognizedLines;
    }

    @Override
    public File getDescriptorFile() {
        return this.descriptorFile;
    }
}

