/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.internal;

import io.prometheus.client.servlet.common.adapter.FilterConfigAdapter;
import io.prometheus.client.servlet.common.adapter.HttpServletRequestAdapter;
import io.prometheus.client.servlet.common.adapter.HttpServletResponseAdapter;
import io.prometheus.client.servlet.common.adapter.ServletConfigAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Adapter {
    public static HttpServletRequestAdapter wrap(HttpServletRequest req) {
        return new HttpServletRequestAdapterImpl(req);
    }

    public static HttpServletResponseAdapter wrap(HttpServletResponse resp) {
        return new HttpServletResponseAdapterImpl(resp);
    }

    public static FilterConfigAdapter wrap(FilterConfig filterConfig) {
        return new FilterConfigAdapterImpl(filterConfig);
    }

    public static ServletConfigAdapter wrap(ServletConfig servletConfig) {
        return new ServletConfigAdapterImpl(servletConfig);
    }

    private static class ServletConfigAdapterImpl
    implements ServletConfigAdapter {
        final ServletConfig delegate;

        private ServletConfigAdapterImpl(ServletConfig delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getInitParameter(String name) {
            return this.delegate.getInitParameter(name);
        }
    }

    private static class FilterConfigAdapterImpl
    implements FilterConfigAdapter {
        private final FilterConfig delegate;

        private FilterConfigAdapterImpl(FilterConfig delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getInitParameter(String name) {
            return this.delegate.getInitParameter(name);
        }
    }

    private static class HttpServletResponseAdapterImpl
    implements HttpServletResponseAdapter {
        private final HttpServletResponse delegate;

        HttpServletResponseAdapterImpl(HttpServletResponse delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setStatus(int httpStatusCode) {
            this.delegate.setStatus(httpStatusCode);
        }

        @Override
        public void setContentType(String contentType) {
            this.delegate.setContentType(contentType);
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            return this.delegate.getWriter();
        }

        @Override
        public int getStatus() {
            return this.delegate.getStatus();
        }
    }

    private static class HttpServletRequestAdapterImpl
    implements HttpServletRequestAdapter {
        private final HttpServletRequest delegate;

        HttpServletRequestAdapterImpl(HttpServletRequest delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getHeader(String name) {
            return this.delegate.getHeader(name);
        }

        @Override
        public String getRequestURI() {
            return this.delegate.getRequestURI();
        }

        @Override
        public String getMethod() {
            return this.delegate.getMethod();
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.delegate.getParameterValues(name);
        }

        @Override
        public String getContextPath() {
            return this.delegate.getContextPath();
        }
    }
}

